# 画面設計書 156-Cat プラグイン

## 概要

本ドキュメントは、OpenSearchのCat Plugins API（`GET /_cat/plugins`）エンドポイントに関する画面設計書である。クラスタ内の各ノードにインストールされたプラグイン情報をテーブル形式で返すAPIの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：クラスタ内の各ノードにインストールされたプラグインの名前、バージョン、説明を一覧形式で確認するために使用される。プラグインのバージョン不整合の検出やインストール状況の確認に活用される。

**画面へのアクセス方法**：HTTPクライアントから `GET /_cat/plugins` にリクエストを送信してアクセスする。

**主要な操作・処理内容**：
1. ClusterStateRequestでノード一覧を取得する
2. NodesInfoRequestでプラグイン情報を取得する
3. 各ノードのプラグインごとに1行のテーブル行を構築する

**画面遷移**：本APIはステートレスなREST APIである。ノード情報API（`GET /_nodes/plugins`）と関連する情報をテーブル形式で表示する。

**権限による表示制御**：セキュリティプラグインが有効な場合、クラスタモニタリング権限が必要となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 49 | ノード情報・統計 | 関連機能 | ノードにインストールされたプラグイン情報をテーブル形式で返す処理 |

## 画面種別

一覧（テーブル形式のプラグイン情報表示）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cat/plugins` | プラグイン情報をテーブル形式で返す |

## 入出力項目

### リクエストパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| format | string | No | - | レスポンス形式（json, yamlなど） |
| local | boolean | No | false | ローカル情報を返す |
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | 30s | **非推奨**: cluster_manager_timeoutを使用 |
| h | list | No | - | 表示するカラム名のカンマ区切りリスト |
| help | boolean | No | false | ヘルプ情報を返す |
| s | list | No | - | ソートするカラム名のカンマ区切りリスト |
| v | boolean | No | false | 冗長モード。カラムヘッダーを表示 |

## 表示項目

| カラム名 | エイリアス | デフォルト表示 | 説明 |
|---------|-----------|-------------|------|
| id | - | No | ノードID |
| name | n | Yes | ノード名 |
| component | c | Yes | プラグインコンポーネント名 |
| version | v | Yes | プラグインバージョン |
| description | d | No | プラグインの説明 |

## イベント仕様

### 1-GETリクエスト受信

クライアントからのGETリクエストを受信すると、`RestPluginsAction.doCatRequest()` が呼び出される。ClusterStateRequestでノード一覧を取得後、NodesInfoRequestでプラグイン情報を取得し、各ノードの各プラグインについてテーブル行を構築する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GETリクエスト | - | SELECT | 参照のみ。データベースへの更新は発生しない |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|--------------|------|-------------|
| 正常応答 | プラグイン情報取得成功時 | テーブル形式のプラグイン情報 |

## 例外処理

- ノード情報が取得できない場合：該当ノードのプラグイン情報はスキップされる（行126-128のnullチェック）
- PluginsAndModulesがnullの場合：該当ノードのプラグイン情報はスキップされる（行130-132のnullチェック）

## 備考

- 各ノードのプラグインごとに1行出力されるため、行数はノード数 x プラグイン数
- 本APIはプラグイン情報のみを返し、モジュール情報は含まない（PluginInfosのみ使用）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PluginInfo.java | `server/src/main/java/org/opensearch/plugins/PluginInfo.java` | getName(), getVersion(), getDescription()を保持 |
| 1-2 | PluginsAndModules.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/info/PluginsAndModules.java` | getPluginInfos()でプラグインリストを返す |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestPluginsAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestPluginsAction.java` | Cat Plugins APIのエントリーポイント |

**主要処理フロー**:
1. **行67-68**: `routes()` で `GET /_cat/plugins` を登録
2. **行82-105**: `doCatRequest()` でClusterState -> NodesInfoの2段階リクエスト
3. **行108-118**: `getTableWithHeader()` で5カラムのテーブルヘッダー定義
4. **行120-145**: `buildTable()` でノード・プラグインごとのテーブル行構築

### プログラム呼び出し階層図

```
RestPluginsAction.doCatRequest() [行82]
    |
    +-- ClusterStateRequest (nodes=true) [行83-84]
    |
    +-- client.admin().cluster().state() [行91]
           |
           +-- NodesInfoRequest (PLUGINS) [行94-96]
           |
           +-- client.admin().cluster().nodesInfo() [行97]
                  |
                  +-- buildTable() [行120]
                         +-- getTableWithHeader() [行108]
                         +-- PluginsAndModules.getPluginInfos() [行133]
```

### データフロー図

```
[入力]               [処理]                      [出力]

GET /_cat/plugins --> RestPluginsAction          --> テーブル形式
                      |
                      v
                 ClusterState (ノード一覧)
                      |
                      v
                 NodesInfo (プラグイン情報)
                      |
                      v
                 buildTable() (ノード x プラグインごとに1行)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestPluginsAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestPluginsAction.java` | ソース | Cat Plugins APIのRESTハンドラ |
| AbstractCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` | ソース | Cat API共通基底クラス |
| PluginInfo.java | `server/src/main/java/org/opensearch/plugins/PluginInfo.java` | ソース | プラグイン情報データ構造 |
| PluginsAndModules.java | `server/src/main/java/org/opensearch/action/admin/cluster/node/info/PluginsAndModules.java` | ソース | プラグイン・モジュール一覧 |
| cat.plugins.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.plugins.json` | 設定 | REST API仕様定義 |
